<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin - {{ config('app.name', 'Klinik Kecantikan') }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Abel:wght@400&display=swap" rel="stylesheet" />
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="font-abel antialiased bg-[#F6F6F6]">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div
            class="w-64 bg-[#8B8B8B] text-white shadow-lg fixed left-0 top-0 h-full overflow-y-auto z-50 hidden lg:block">
            <!-- Logo Section -->
            <div class="p-6 border-b border-[#CBB4B0]">
                <div class="flex items-center">
                    <div
                        class="w-12 h-12 rounded-xl flex items-center justify-center mr-4 overflow-hidden">
                        <img src="{{ asset('images/logo/LOGO ZEN.jpg') }}" alt="Logo"
                            class="w-10 h-10 object-contain" onerror="this.style.display='none';">
                    </div>
                    <div>
                        <h1 class="text-xl font-bold text-white">Admin Panel</h1>
                        <p class="text-sm text-white">Klinik Kecantikan</p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="mt-6">
                <!-- Main Menu -->
                <div class="px-4 mb-6">
                    <h3 class="text-xs font-semibold text-white uppercase tracking-wider mb-3">Menu Utama</h3>
                </div>

                <div class="space-y-1 px-3">
                    <!-- Dashboard -->
                    <a href="{{ route('dashboard') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('dashboard') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 5a2 2 0 012-2h4a2 2 0 012 2v6H8V5z"></path>
                        </svg>
                        Dashboard
                    </a>

                    <!-- Kelola Pasien -->
                    <a href="{{ route('admin.patients.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.patients.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z">
                            </path>
                        </svg>
                        Kelola Pasien
                    </a>

                    <!-- Kredensial Pasien -->
                    <a href="{{ route('admin.patient-management.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.patient-management.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z">
                            </path>
                        </svg>
                        Kredensial Pasien
                    </a>

                    <!-- Kelola Perusahaan -->
                    <a href="{{ route('admin.companies.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.companies.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                            </path>
                        </svg>
                        Kelola Perusahaan
                    </a>

                    <!-- Kelola Karyawan -->
                    <a href="{{ route('admin.employees.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.employees.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z">
                            </path>
                        </svg>
                        Kelola Karyawan
                    </a>

                    <!-- Kelola Partner -->
                    <a href="{{ route('admin.partners.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.partners.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z">
                            </path>
                        </svg>
                        Kelola Partner
                    </a>

                    <!-- Hasil Pemeriksaan -->
                    <a href="{{ route('admin.exam-results.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.exam-results.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                        Hasil Pemeriksaan
                    </a>

                    <!-- Pembayaran -->
                    <a href="{{ route('admin.payments.index') }}"
                        class="flex items-center px-3 py-3 text-sm font-medium rounded-none transition-all duration-200 {{ request()->routeIs('admin.payments.*') ? 'bg-[#192D50] text-white shadow-lg' : 'text-gray-300 hover:text-white hover:bg-[#192D50]' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                            </path>
                        </svg>
                        Pembayaran
                    </a>
                </div>

                <!-- Quick Stats -->
                <div class="px-4 mt-8">
                    <div class="bg-[#192D50] rounded-none p-4">
                        <h4 class="text-sm font-semibold text-white mb-3">Quick Stats</h4>
                        <div class="space-y-2">
                            <div class="flex justify-between items-center">
                                <span class="text-xs text-white">Total Pasien</span>
                                <span
                                    class="text-sm font-semibold text-white">{{ \App\Models\Patient::count() }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-xs text-white">Hasil Pemeriksaan</span>
                                <span
                                    class="text-sm font-semibold text-white">{{ \App\Models\ExamResult::count() }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-xs text-white">Registrasi Hari Ini</span>
                                <span
                                    class="text-sm font-semibold text-white">{{ \App\Models\Registration::whereDate('created_at', today())->count() }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-xs text-white">Total Partner</span>
                                <span
                                    class="text-sm font-semibold text-white">{{ \App\Models\Partner::count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col lg:ml-64">
            <!-- Top Navigation -->
            <header class="bg-[#F6F6F6] shadow-sm border-b border-[#CBB4B0]">
                <div class="flex items-center justify-between px-6 py-4">
                    <div class="flex items-center">
                        <button class="text-gray-500 hover:text-gray-700 focus:outline-none focus:text-gray-700">
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>

                    <div class="flex items-center space-x-4">
                        <a href="{{ url('/') }}" class="text-gray-600 hover:text-gray-900 text-sm font-medium">
                            Lihat Website
                        </a>

                        <div class="relative">
                            <button
                                class="flex items-center text-sm font-medium text-gray-700 hover:text-gray-900 focus:outline-none">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center mr-2">
                                    <span
                                        class="text-white text-sm font-bold">{{ substr(Auth::user()->name, 0, 1) }}</span>
                                </div>
                                {{ Auth::user()->name }}
                                <svg class="ml-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                        </div>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="text-gray-600 hover:text-gray-900 text-sm font-medium">
                                Logout
                            </button>
                        </form>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1">
                @yield('content')
            </main>
        </div>
    </div>
</body>

</html>
